package ru.yandex.solomon.model.timeseries.iterator;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface GenericCursor<T> {
    /**
     * Should return 0 if no point has been consumed yet
     * Should return current point timestamp otherwise
     */
    long getTimestamp();

    /**
     * If stream has more points, consume next and return true
     * Otherwise return false
     */
    boolean next();

    GenericIterator<T> getIterator();
}
