package ru.yandex.solomon.model.timeseries.iterator;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface GenericIterator<T> {
    /**
     * If end of stream is reached, returns false. Otherwise fills target and returns true
     */
    boolean next(T target);

    /**
     * @return estimated iterator points count, or -1 if estimate is not available
     */
    int estimatePointsCount();

    static <T> GenericIterator<T> empty() {
        return new GenericIterator<>() {
            @Override
            public boolean next(@Nonnull T target) {
                return false;
            }

            @Override
            public int estimatePointsCount() {
                return 0;
            }
        };
    }
}
