package ru.yandex.solomon.model.timeseries.iterator;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface GenericPointCollector<C extends GenericCursor, T> {
    /**
     * Reset collector's state
     */
    void reset();

    /**
     * Append current point from cursor to collector. Cursor's current point is guaranteed to be valid
     */
    void append(int cursorIndex, C cursor);

    /**
     * Combine collected values into target at specified time
     */
    void compute(long timestamp, T target);
}
