package ru.yandex.solomon.model.timeseries.view;

import javax.annotation.Nonnull;

import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayListOrView;
import ru.yandex.solomon.util.collection.array.DoubleArrayView;
import ru.yandex.solomon.util.collection.array.LongArrayView;

/**
 * @author Vladimir Gordiychuk
 */
public class AggrGraphDataDoubleTimeSeriesView implements DoubleTimeSeriesView {

    private final AggrGraphDataArrayListOrView source;

    public AggrGraphDataDoubleTimeSeriesView(AggrGraphDataArrayListOrView source) {
        this.source = source;

        if (!source.hasColumn(StockpileColumn.TS) || !source.hasColumn(StockpileColumn.VALUE)) {
            if (!source.isEmpty()) {
                String message =
                    "invalid source columns: " + source.columnSet() + ", TS and VALUE are required";
                throw new IllegalArgumentException(message);
            }
        }
    }

    @Nonnull
    @Override
    public LongArrayView getTimeView() {
        return source.getTimestamps();
    }

    @Override
    public long getTsMillis(int index) {
        return source.getTsMillis(index);
    }

    @Override
    public int length() {
        return source.length();
    }

    @Nonnull
    @Override
    public DoubleTimeSeriesView slice(int from, int to) {
        return new AggrGraphDataDoubleTimeSeriesView(source.slice(from, to));
    }

    @Nonnull
    @Override
    public DoubleArrayView getValueView() {
        double[] doubles = source.dividedValues();
        return new DoubleArrayView(doubles);
    }

    @Override
    public double getValue(int index) {
        return source.getValueDivided(index);
    }

    public AggrGraphDataArrayListOrView getSource() {
        return source;
    }
}
