package ru.yandex.solomon.model.timeseries.view;

import java.util.stream.DoubleStream;
import java.util.stream.IntStream;

import javax.annotation.Nonnull;

import ru.yandex.solomon.util.collection.array.DoubleArrayView;

/**
 * @author Vladimir Gordiychuk
 */
public interface DoubleTimeSeriesView extends TimeSeriesView<DoubleTimeSeriesView> {
    /**
     *
     * Note: try to avoid use this method, because it can allocate array with values in case when data compacted to
     * another structure
     * @return new instance view with filled value array.
     */
    @Nonnull
    DoubleArrayView getValueView();

    double getValue(int index);

    default DoubleStream streamValues() {
        return IntStream.range(0, length())
            .mapToDouble(this::getValue);
    }
}
