package ru.yandex.solomon.model.timeseries.view;

import javax.annotation.Nonnull;

import ru.yandex.solomon.util.collection.array.LongArrayView;

/**
 * @author Vladimir Gordiychuk
 */
public interface TimeSeriesView<T extends TimeSeriesView<T>> {
    @Nonnull
    LongArrayView getTimeView();

    long getTsMillis(int index);

    int length();

    default boolean isEmpty() {
        return length() == 0;
    }

    @Nonnull
    T slice(int from, int to);
}
