package ru.yandex.solomon.model.type;

import ru.yandex.monlib.metrics.summary.ImmutableSummaryInt64Snapshot;
import ru.yandex.monlib.metrics.summary.SummaryInt64Snapshot;

/**
 * Copy-past from {@link java.util.LongSummaryStatistics} with support reset to be able
 * reuse same object for multiple aggregations.
 *
 * @author Vladimir Gordiychuk
 * @see java.util.LongSummaryStatistics
 */
public class MutableSummaryInt64 {
    private long count;
    private long sum;
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private long last;

    public void reset() {
        count = 0;
        sum = 0;
        min = Long.MAX_VALUE;
        max = Long.MIN_VALUE;
        last = 0;
    }

    public void addSummary(SummaryInt64Snapshot snapshot) {
        count += snapshot.getCount();
        sum += snapshot.getSum();
        min = Math.min(min, snapshot.getMin());
        max = Math.max(max, snapshot.getMax());
        last = snapshot.getLast();
    }

    public long getCount() {
        return count;
    }

    public long getSum() {
        return sum;
    }

    public long getMin() {
        return min;
    }

    public long getMax() {
        return max;
    }

    public long getLast() {
        return last;
    }

    public final double getAverage() {
        return getCount() > 0 ? (double) getSum() / getCount() : 0.0d;
    }

    public SummaryInt64Snapshot snapshot() {
        return new ImmutableSummaryInt64Snapshot(getCount(), getSum(), getMin(), getMax(), getLast());
    }
}
