package ru.yandex.solomon.model.type.ugram;

import javax.annotation.Nonnull;

import io.netty.util.Recycler;

/**
 * @author Vladimir Gordiychuk
 */
public class Bucket implements Comparable<Bucket> {
    private static final Recycler<Bucket> RECYCLER = new Recycler<>() {
        protected Bucket newObject(Handle<Bucket> handle) {
            return new Bucket(handle);
        }
    };

    private final Recycler.Handle<Bucket> handle;

    public double lowerBound;
    public double upperBound;
    public double weight;
    public double minDens;
    public double maxDens;
    public double damage;

    private Bucket(Recycler.Handle<Bucket> handle) {
        this.handle = handle;
    }

    public static Bucket create() {
        return RECYCLER.get();
    }

    public static Bucket create(double lowerBound, double upperBound, double weight) {
        var bucket = RECYCLER.get();
        bucket.lowerBound = lowerBound;
        bucket.upperBound = upperBound;
        bucket.weight = weight;
        return bucket;
    }

    public double size() {
        return upperBound - lowerBound;
    }

    public void recycle() {
        lowerBound = 0;
        upperBound = 0;
        weight = 0;
        minDens = 0;
        maxDens = 0;
        damage = 0;
        handle.recycle(this);
    }

    @Override
    public int compareTo(@Nonnull Bucket that) {
        int compare = Double.compare(this.lowerBound, that.lowerBound);
        if (compare != 0) {
            return compare;
        }

        return Double.compare(this.upperBound, that.upperBound);
    }

    @Override
    public String toString() {
        return "Bucket{" +
            "lowerBound=" + lowerBound +
            ", upperBound=" + upperBound +
            ", weight=" + weight +
            '}';
    }
}
