package ru.yandex.solomon.model.type.ugram;

import java.util.List;

import ru.yandex.monlib.metrics.histogram.Histograms;

/**
 * @author Vladimir Gordiychuk
 */
public class Compress {
    private static final int MAX_SIZE = Histograms.MAX_BUCKETS_COUNT - 1;

    public static void compress(List<Bucket> buckets) {
        if (buckets.size() < MAX_SIZE) {
            return;
        }

        // Initial compress
        buckets.removeIf(bucket -> Double.compare(bucket.weight, 0) == 0);
        if (buckets.size() > 100) {
            FastCompress.compress(buckets, 100);
        }

        if (buckets.size() > MAX_SIZE) {
            SlowCompress.compress(buckets, MAX_SIZE);
        }
    }
}
