package ru.yandex.solomon.model.type.ugram;

import java.util.List;

/**
 * @author Vladimir Gordiychuk
 */
public class FastCompress {

    // https://a.yandex-team.ru/arc/trunk/arcadia/infra/yasm/zoom/components/hgram/ugram/compress/fast.cpp
    public static void compress(List<Bucket> buckets, int limit) {
        // save latest point as is for compatibility reason
        var latest = buckets.remove(buckets.size() - 1);
        do {
            int lessDamageIdx = -1;
            double lessDamage = Double.MAX_VALUE;
            int windowSize = 0;
            // iterate, every 4 merge max
            for (int index = 1; index < buckets.size(); index++) {
                {
                    var left = buckets.get(index - 1);
                    if (left.damage == 0.0) {
                        var right = buckets.get(index);
                        left.damage = estimateDamage(left, right);
                    }

                    if (lessDamageIdx == -1 || Double.compare(lessDamage, left.damage) > 0) {
                        lessDamage = left.damage;
                        lessDamageIdx = index;
                    }
                }

                if (++windowSize == 3) {
                    Bucket left = buckets.get(lessDamageIdx - 1);
                    Bucket right = buckets.remove(lessDamageIdx);
                    combine(left, right);
                    right.recycle();
                    index = lessDamageIdx;
                    windowSize = 0;
                    lessDamage = Double.MAX_VALUE;
                }
            }

            if (windowSize != 0) {
                Bucket left = buckets.get(lessDamageIdx - 1);
                Bucket right = buckets.remove(lessDamageIdx);
                combine(left, right);
                right.recycle();
            }
        } while (buckets.size() - 1 > limit);
        buckets.add(latest);
    }

    private static void combine(Bucket left, Bucket right) {
        left.upperBound = right.upperBound;
        left.weight += right.weight;
        left.damage = 0.0;
    }

    private static double estimateDamage(Bucket left, Bucket right) {
        var weight = left.weight + right.weight;

        var midBound = right.lowerBound;
        var leftDensity = left.weight / (midBound - left.lowerBound);
        var rightDensity = right.weight / (right.upperBound - midBound);

        final double minDens;
        final double maxDens;
        if (Double.compare(leftDensity, rightDensity) <= 0) {
            minDens = leftDensity;
            maxDens = rightDensity;
        } else {
            minDens = rightDensity;
            maxDens = leftDensity;
        }

        var commonDensity = weight / (right.upperBound - left.lowerBound);
        return Math.max(maxDens / commonDensity, commonDensity / minDens);
    }
}
