package ru.yandex.solomon.model.type.ugram;

import java.util.List;

/**
 * @author Vladimir Gordiychuk
 */
public class SlowCompress {
    // https://a.yandex-team.ru/arc/trunk/arcadia/infra/yasm/zoom/components/hgram/ugram/compress/slow.cpp
    public static void compress(List<Bucket> buckets, int limit) {
        for (int index = 1; index < buckets.size(); index++) {
            var left = buckets.get(index - 1);
            var right = buckets.get(index);
            left.damage = estimateDamage(left, right);
        }

        do {
            int lessDamageIdx = 1;
            double lessDamage = buckets.get(0).damage;
            for (int index = 1; index < buckets.size(); index++) {
                var left = buckets.get(index - 1);
                if (Double.compare(lessDamage, left.damage) > 0) {
                    lessDamage = left.damage;
                    lessDamageIdx = index;
                }
            }

            mergeNeighbor(buckets, lessDamageIdx);
        } while (buckets.size() > limit);
    }

    private static void mergeNeighbor(List<Bucket> buckets, int lessDamageIdx) {
        Bucket left = buckets.get(lessDamageIdx - 1);
        Bucket right = buckets.remove(lessDamageIdx);
        left.upperBound = right.upperBound;
        left.weight += right.weight;
        if (lessDamageIdx < buckets.size()) {
            var nextRight = buckets.get(lessDamageIdx);
            left.damage = estimateDamage(left, nextRight);
        } else {
            left.damage = 0.0;
        }
        right.recycle();
    }

    private static double estimateDamage(Bucket left, Bucket right) {
        var totalWeight = left.weight + right.weight;
        var totalSize = right.upperBound - left.lowerBound;
        var maxBucketDensity = Math.max(left.weight / left.size(), right.weight / right.size());
        return maxBucketDensity / (totalWeight / totalSize);
    }

}
