package ru.yandex.solomon.unified.agent;

import io.netty.channel.ChannelOption;

import ru.yandex.grpc.utils.client.interceptors.MetricClientInterceptor;
import ru.yandex.logbroker.agent.client.Client;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.config.protobuf.TUnifiedAgentClientConfig;
import ru.yandex.solomon.config.thread.ThreadPoolProvider;
import ru.yandex.solomon.util.NettyUtils;

import static ru.yandex.solomon.config.OptionalSet.setBytesSize;
import static ru.yandex.solomon.config.OptionalSet.setTimeMillis;

/**
 * @author Vladimir Gordiychuk
 */
public class UnifiedAgentClients {

    public static Client makeClient(TUnifiedAgentClientConfig config, ThreadPoolProvider threads, MetricRegistry registry) {
        var executor = threads.getExecutorService(config.getThreadPoolName(), "ThreadPoolName");
        var ioExecutor = threads.getIOExecutor();

        var builder = Client.newClient(config.getUri())
                .setChannelCustomizer(channel -> {
                    channel.offloadExecutor(executor);
                    channel.channelType(NettyUtils.clientDomainSocketChannelForEventLoop(ioExecutor));
                    channel.eventLoopGroup(ioExecutor);
                    setBytesSize(channel::maxInboundMessageSize, config.getMaxInboundMessageSize());
                    setTimeMillis(value -> channel.withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, value), config.getConnectTimeout());
                    channel.intercept(new MetricClientInterceptor("solomon", registry));
                });

        setBytesSize(builder::setGrpcMaxMessageSize, config.getMaxOutboundMessageSize());
        setBytesSize(builder::setMaxInflightBytes, config.getMaxMessageQueueSize());
        builder.setMetricRegistry(registry);
        return builder.build();
    }
}
