package ru.yandex.solomon.util;

import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

import ru.yandex.solomon.util.text.TextWithNumbersComparator;

/**
 * @author Vladimir Gordiychuk
 */
@Fork(value = 1)
@Measurement(iterations = 10, time = 1, timeUnit = TimeUnit.SECONDS)
@Warmup(iterations = 5, time = 1, timeUnit = TimeUnit.SECONDS)
@State(Scope.Thread)
@Threads(1) //current test not support concurrent execution
@BenchmarkMode(Mode.AverageTime)
@OutputTimeUnit(TimeUnit.NANOSECONDS)
public class TextWithNumberComparatorJmhBench {
    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder()
                .include(TextWithNumberComparatorJmhBench.class.getName())
                .detectJvmArgs()
                .build();

        new Runner(opt).run();
    }

    @Benchmark
    public int compare() {
        String a = "/place/db/iss3/instances/10575_rtc_sla_tentacles_production_vla_8JOeBzmkObC";
        String b = "/place/db/iss3/instances/10575_rtc_sla_tentacles_production_vla_2O8eGyonmaQ";
        return TextWithNumbersComparator.instance.compare(a, b);
    }
}
