package ru.yandex.solomon.util.collection.unpacked.arrayList;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

/**
 * @author Stepan Koltsov
 */
@State(Scope.Thread)
@OutputTimeUnit(TimeUnit.MICROSECONDS)
@Warmup(iterations = 7)
@Measurement(iterations = 6)
@BenchmarkMode(Mode.AverageTime)
@Fork(2)
public class UnpackedArrayListBenchmark {


    private static class Data {
        private final int value;
        private final String s;
        private final boolean b;

        public Data(int value, String s, boolean b) {
            this.value = value;
            this.s = s;
            this.b = b;
        }
    }

    private static final UnpackedArrayList.Factory<Data> f = new UnpackedArrayList.Factory<>(Data.class);


    public static void main(String[] args) throws Exception {
        Options opt = new OptionsBuilder()
                .include(UnpackedArrayListBenchmark.class.getSimpleName())
                .build();
        new Runner(opt).run();
    }

    private static final int iter = 1000;

    @Benchmark
    public void unpacked(Blackhole blackhole) {
        UnpackedArrayList<Data> list = f.newWithCapacity(10);

        for (int i = 0; i < iter; ++i) {
            list.add(new Data(i, "aa", i % 2 == 0));
            blackhole.consume(list);
        }
    }

    @Benchmark
    public void javaUtil(Blackhole blackhole) {
        ArrayList<Data> list = new ArrayList<>(10);

        for (int i = 0; i < iter; ++i) {
            list.add(new Data(i, "aa", i % 2 == 0));
            blackhole.consume(list);
        }
    }

}
