package ru.yandex.solomon.util;

import java.util.List;

import javax.annotation.Nullable;

import io.netty.util.ReferenceCounted;

/**
 * @author Vladimir Gordiychuk
 */
public class CloseableUtils {
    public static void release(@Nullable ReferenceCounted... targets) {
        if (targets == null) {
            return;
        }

        for (int index = 0; index < targets.length; index++) {
            var target = targets[index];
            if (target == null) {
                continue;
            }

            try {
                target.release();
            } catch (Exception e) {
                throw new RuntimeException("index " + index, e);
            }
        }
    }

    public static void close(@Nullable AutoCloseable... targets) {
        if (targets == null) {
            return;
        }

        for (int index = 0; index < targets.length; index++) {
            var target = targets[index];
            if (target == null) {
                continue;
            }

            try {
                target.close();
            } catch (Exception e) {
                throw new RuntimeException("index " + index, e);
            }
        }
    }

    public static void close(List<? extends AutoCloseable> targets) {
        for (var target : targets) {
            if (target == null) {
                continue;
            }

            try {
                target.close();
            } catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}
