package ru.yandex.solomon.util;

/**
 * @author Stepan Koltsov
 */
public class ComparableUtils {

    @SuppressWarnings("unchecked")
    public static <E extends Comparable<E>> int compare(E a1, E b1) {
        if (a1 == b1) {
            return 0;
        } else if (a1 == null) {
            return -1;
        } else if (b1 == null) {
            return 1;
        } else {
            return a1.compareTo(b1);
        }
    }

    public static <A extends Comparable<A>, B extends Comparable<B>> int compare(A a1, B a2, A b1, B b2) {
        int r;
        r = compare(a1, b1);
        if (r != 0) return r;
        r = compare(a2, b2);
        if (r != 0) return r;
        return r;
    }

}
