package ru.yandex.solomon.util;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.parser.ParserSupport;

/**
 * @author Maksim Leonov (nohttp@)
 */
@ParametersAreNonnullByDefault
public class Escaper {
    private final char[] specialChars;
    private final char escapeChar;

    public Escaper(String specialChars, char escapeChar) {
        this.escapeChar = escapeChar;
        this.specialChars = (specialChars + escapeChar).toCharArray();
        Arrays.sort(this.specialChars);
    }

    public void escapeTo(String in, StringBuilder to) {
        for (char c : in.toCharArray()) {
            if (Arrays.binarySearch(specialChars, c) >= 0) {
                to.append(escapeChar);
            }
            to.append(c);
        }
    }

    public String consumeUntil(ParserSupport parser, char e) {
        StringBuilder result = new StringBuilder();
        while (parser.hasNext() && parser.lookahead() != e) {
            char c = parser.consumeChar();
            if (c == escapeChar) {
                c = parser.consumeChar();
                if (Arrays.binarySearch(specialChars, c) < 0) {
                    result.append(escapeChar);
                }
            }
            result.append(c);
        }
        return result.toString();
    }
}
