package ru.yandex.solomon.util;

import java.lang.management.ThreadInfo;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Stepan Koltsov
 */
public class ExceptionUtils {

    public static String printStackTrace(Throwable e) {
        return ru.yandex.misc.ExceptionUtils.getStackTrace(e);
    }

    public static String printStackTrace(ThreadInfo threadInfo) {
        return printStackTrace(threadInfo.getStackTrace());
    }

    public static String printStackTrace(StackTraceElement[] stackTrace) {
        return Stream.of(stackTrace).map(s -> s.toString() + "\n")
                .collect(Collectors.joining());
    }

    public static boolean isBrokenPipe(Throwable e) {
        String message = e.getMessage();
        message = (message != null) ? message.toLowerCase() : "";
        return message.contains("broken pipe") || message.contains("connection reset by peer");
    }

    public static void uncaughtException(Throwable x) {
        Thread thread = Thread.currentThread();
        var handler = thread.getUncaughtExceptionHandler();
        handler.uncaughtException(thread, x);
    }
}
