package ru.yandex.solomon.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.OptionalLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.annotation.Nullable;


/**
 * @author Sergey Polovko
 */
public final class JvmArgs {
    private JvmArgs() {}

    private static final Pattern MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN = Pattern.compile(
        "\\s*-XX:MaxDirectMemorySize\\s*=\\s*([0-9]+)\\s*([kKmMgG]?)\\s*$");


    public static OptionalLong maxDirectMemorySize() {
        Matcher m = findArgByPattern(MAX_DIRECT_MEMORY_SIZE_ARG_PATTERN);
        if (m != null) {
            long size = Long.parseLong(m.group(1));
            String multiple = m.group(2);
            return OptionalLong.of(fromHumanSize(size, multiple));
        }

        return OptionalLong.empty();
    }

    @Nullable
    private static Matcher findArgByPattern(Pattern pattern) {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMXBean.getInputArguments()) {
            Matcher m = pattern.matcher(arg);
            if (m.matches()) {
                return m;
            }
        }
        return null;
    }

    private static long fromHumanSize(long size, String multiply) {
        if (multiply.isEmpty()) {
            return size;
        }

        switch (multiply.charAt(0)) {
            case 'k':
            case 'K':
                return size << 10;
            case 'm':
            case 'M':
                return size << 20;
            case 'g':
            case 'G':
                return size << 30;
            default:
                throw new IllegalStateException("unsupported multiply: " + multiply);
        }
    }
}
