package ru.yandex.solomon.util;

import javax.annotation.Nullable;

/**
 * @author Sergey Polovko
 */
public final class Numbers {
    private Numbers() {
    }

    public static int parseIntSafe(@Nullable String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        } catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}
