package ru.yandex.solomon.util;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Status;

/**
 * @author Vladimir Gordiychuk
 */
public class Proto {
    public static <T extends Message> T unpack(Any any, T defaultValue) {
        if (Any.getDefaultInstance().equals(any)) {
            return defaultValue;
        }

        return unpack(any, (Class<T>) defaultValue.getClass());
    }

    public static <T extends Message> T unpack(Any any, Class<T> clazz) {
        if (Any.getDefaultInstance().equals(any)) {
            throw Status.INVALID_ARGUMENT
                    .withDescription("Unable unpack as '" + clazz.getName() + ": any is empty")
                    .asRuntimeException();
        }

        if (!any.is(clazz)) {
            throw Status.INVALID_ARGUMENT
                    .withDescription("Unable unpack as '" + clazz.getName() + ": any has different type '" + any.getTypeUrl() + "'")
                    .asRuntimeException();
        }

        try {
            return any.unpack(clazz);
        } catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException("Failed unpack as '" + clazz.getName() + "': '" + any.getTypeUrl() + "'", e);
        }
    }

    public static <T extends com.google.protobuf.Message> Any pack(T message) {
        if (message instanceof Any) {
            return (Any) message;
        }

        return Any.pack(message);
    }
}
