package ru.yandex.solomon.util;

import ru.yandex.misc.lang.CharPredicate;

/**
 * @author Stanislav Kashirin
 */
public final class StringUtils {
    private StringUtils() {
    }

    public static String replaceChars(String str, CharPredicate pred, char replacement) {
        int len = str.length();
        int i = -1;
        while (++i < len) {
            if (pred.matches(str.charAt(i))) {
                break;
            }
        }

        if (i == len) {
            return str;
        }

        var sb = new StringBuilder(len);
        int start = 0, end = i;
        do {
            if (pred.matches(str.charAt(end))) {
                sb.append(str, start, end);
                sb.append(replacement);
                start = end + 1;
            }
        } while (++end < len);

        return sb.append(str, start, end).toString();
    }

}
