package ru.yandex.solomon.util;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class UrlBuilder {

    private final StringBuilder stringBuilder;
    private boolean hasParams;

    public UrlBuilder(String base) {
        this.stringBuilder = new StringBuilder(base);

        int questionMark = base.lastIndexOf('?');
        if (questionMark == base.length() - 1) {
            // remove last '?'
            stringBuilder.setLength(stringBuilder.length() - 1);
        } else if (questionMark != -1) {
            this.hasParams = true;
        }
    }

    public UrlBuilder appendQueryArg(String name, String value) {
        if (hasParams) {
            stringBuilder.append('&');
        } else {
            stringBuilder.append('?');
            hasParams = true;
        }

        stringBuilder.append(name);
        stringBuilder.append('=');
        stringBuilder.append(value); // TODO: escape
        return this;
    }

    public String build() {
        return stringBuilder.toString();
    }
}
