package ru.yandex.solomon.util.actors;

import java.util.concurrent.CompletableFuture;


/**
 * @author Sergey Polovko
 */
public interface AsyncActorBody {

    /**
     * Special marker object to be returned from task implementation
     * as a signal that task is done.
     */
    Object DONE_MARKER = new Object();

    /**
     * @return future result of fired async operation.
     *         If there is no work to do must return CompletableFuture
     *         completed with {@link AsyncActorBody#DONE_MARKER}.
     */
    CompletableFuture<?> run();
}
