package ru.yandex.solomon.util.collection;

import java.util.Iterator;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ForwardingIterator;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public interface CloseableIterator<E> extends Iterator<E>, AutoCloseable {

    static <E> CloseableIterator<E> of(Iterator<E> iterator) {
        return of(iterator, () -> { /* no-op */ });
    }

    static <E> CloseableIterator<E> of(Iterator<E> iterator, Runnable onClose) {
        class Adapter extends ForwardingIterator<E> implements CloseableIterator<E> {

            @Override
            protected Iterator<E> delegate() {
                return iterator;
            }

            @Override
            public void close() {
                onClose.run();
            }
        }

        return new Adapter();
    }

    @Override
    void close();
}
