package ru.yandex.solomon.util.collection;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;

import ru.yandex.bolts.collection.CollectorsF;
import ru.yandex.solomon.util.collection.array.ArrayBuilder;

/**
 * @author Stepan Koltsov
 */
public class Collectors2 {

    public static <K, V, M extends Map<K, V>> Collector<Map.Entry<K, V>, ?, M> backToMap(Supplier<M> whatMap) {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, CollectorsF.throwingMerger(), whatMap);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> backToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(
            Function<? super T, ? extends K> keyMapper,
            Function<? super T, ? extends U> valueMapper,
            Supplier<M> mapSupplier) {
        return Collectors.toMap(keyMapper, valueMapper, CollectorsF.throwingMerger(), mapSupplier);
    }

    public static <K, V> Collector<V, ?, Map<K, V>> toMapMappingToKey(Function<V, K> function) {
        return Collectors.toMap(function, v -> v);
    }

    public static <K, V> Collector<K, ?, Map<K, V>> toMapMappingToValue(Function<K, V> function) {
        return Collectors.toMap(k -> k, function);
    }

    public static <K, V, M extends Map<K, V>> Collector<K, ?, M> toMapMappingToValue(Function<K, V> function, Supplier<M> mapSupplier) {
        return toMap(k -> k, function, mapSupplier);
    }

    public static <K, V, E> Collector<E, ?, Map<K, List<V>>> groupingByToKeyValue(
            Function<E, K> key,
            Function<E, V> value)
    {
        return Collectors.groupingBy(key, Collectors.mapping(value, Collectors.toList()));
    }

    public static <K, V, E> Collector<E, ?, ConcurrentMap<K, List<V>>> groupingByToKeyValueConcurrent(
            Function<E, K> key,
            Function<E, V> value)
    {
        return Collectors.groupingByConcurrent(key, Collectors.mapping(value, Collectors.toList()));
    }

    public static <K, V> Collector<V, ?, ConcurrentMap<K, List<V>>> groupingByToKeyConcurrent(
            Function<V, K> key)
    {
        return groupingByToKeyValueConcurrent(key, v -> v);
    }

    public static <T> Collector<T, ?, ArrayBuilder<T>> toArrayBuilder(T[] emptyArray) {
        return Collector.of(
            () -> new ArrayBuilder<>(emptyArray),
            ArrayBuilder::add,
            (a, b) -> { a.addAll(b); return a; });
    }

    public static <T> Collector<T, ?, T[]> toArray(IntFunction<T[]> array) {
        return Collector.of(
            () -> new ArrayBuilder<>(array.apply(0)),
            ArrayBuilder::add,
            (a, b) -> { a.addAll(b); return a; },
            ArrayBuilder::build);
    }

    public static <T> Collector<T, ?, Object[]> toArray() {
        return (Collector<T, ?, Object[]>) toArray(i -> new Object[0]);
    }

    public static <T> Collector<T, ?, T[]> toArrayUnsafe() {
        return (Collector<T, ?, T[]>) (Collector<?, ?, ?>) toArray();
    }

    public static <T> Collector<T, ?, Multiset<T>> toMultiSet() {
        return toMultiSet(HashMultiset::<T>create);
    }

    public static <T> Collector<T, ?, Multiset<T>> toMultiSet(Supplier<Multiset<T>> supplier) {
        return Collector.of(
                supplier,
                Multiset::add,
                ( l, r ) -> { l.addAll( r ); return l; },
                l -> l,
                Collector.Characteristics.IDENTITY_FINISH,
                Collector.Characteristics.UNORDERED);
    }
}
