package ru.yandex.solomon.util.collection;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Stepan Koltsov
 */
public class GroupByFlat {

    public interface BinaryPredicate<A> {
        boolean test(A x, A y);
    }

    public static <A> List<List<A>> groupBy(List<A> list, BinaryPredicate<A> p) {
        ArrayList<List<A>> r = new ArrayList<>();
        int pos = 0;
        while (pos < list.size()) {
            ArrayList<A> group = new ArrayList<>();

            A first = list.get(pos);
            group.add(first);

            int i;
            for (i = 1;
                pos + i < list.size() && p.test(first, list.get(pos + i));
                ++i)
            {
                group.add(list.get(pos + i));
            }

            r.add(group);
            pos += i;
        }
        return r;
    }

}
