package ru.yandex.solomon.util.collection;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;

/**
 * @author Stepan Koltsov
 */
public class LikeMap {

    public static <K, V, E extends Map.Entry<K, V>> Collector<E, ?, String> collectorToString() {
        return Collectors.mapping(
            e -> new AbstractMap.SimpleEntry<>(e.getKey(), e.getValue()).toString(),
            Collectors.joining(", ", "{", "}"));
    }

}
