package ru.yandex.solomon.util.collection;

import java.util.Comparator;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
public final class NanComparator implements Comparator<Double> {
    private final boolean nanFirst;
    private final Comparator<Double> comparator;

    private NanComparator(boolean nanFirst, Comparator<Double> comparator) {
        this.nanFirst = nanFirst;
        this.comparator = comparator;
    }

    @Override
    public int compare(Double o1, Double o2) {
        if (o1.isNaN() && o2.isNaN()) {
            return 0;
        }

        if (o1.isNaN()) {
            return nanFirst ? -1 : 1;
        } else if (o2.isNaN()) {
            return nanFirst ? 1: -1;
        } else {
            return comparator.compare(o1, o2);
        }
    }

    @Override
    public Comparator<Double> reversed() {
        return new NanComparator(!nanFirst, comparator.reversed());
    }

    public static Comparator<Double> nanFirst(Comparator<Double> comparator) {
        return new NanComparator(true, comparator);
    }

    public static Comparator<Double> nanLast(Comparator<Double> comparator) {
        return new NanComparator(false, comparator);
    }
}
