package ru.yandex.solomon.util.collection;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import ru.yandex.bolts.collection.Cf;

/**
 * @author Stepan Koltsov
 */
public class Nullables {

    @Nullable
    public static <A, B> B map(@Nullable A a, @Nonnull Function<A, B> f) {
        return a != null ? f.apply(a) : null;
    }

    @Nullable
    public static <A> A filter(@Nullable A a, @Nonnull Predicate<A> p) {
        return a != null && p.test(a) ? a : null;
    }

    @Nonnull
    public static String orEmpty(@Nullable String v) {
        return v == null ? "" : v;
    }

    @Nonnull
    public static String[] orEmpty(@Nullable String[] v) {
        return v == null ? Cf.StringArray.emptyArray() : v;
    }

    @Nonnull
    public static Instant orEpoch(@Nullable Instant v) {
        return v == null ? Instant.EPOCH : v;
    }

    @Nonnull
    public static <K, V> Map<K, V> orEmpty(@Nullable Map<K, V> v) {
        return v == null ? Collections.emptyMap() : v;
    }

    @Nonnull
    public static <V> Set<V> orEmpty(@Nullable Set<V> v) {
        return v == null ? Collections.emptySet() : v;
    }

    @Nonnull
    public static <V> List<V> orEmpty(@Nullable List<V> v) {
        return v == null ? Collections.emptyList() : v;
    }

    public static boolean orFalse(@Nullable Boolean v) {
        return v == null ? false : v;
    }

    public static int orZero(@Nullable Integer v) {
        return v == null ? 0 : v;
    }

    public static double orZero(@Nullable Double v) {
        return v == null ? 0.0 : v;
    }

    public static long orZero(@Nullable Long v) {
        return v == null ? 0L : v;
    }

    public static int orDefault(@Nullable Integer v, int dflt) {
        return v == null ? dflt : v;
    }

    public static long orDefault(@Nullable Long v, long dflt) {
        return v == null ? dflt : v;
    }

    public static <V> V orDefault(@Nullable V v, V dflt) {
        return v == null ? dflt : v;
    }
}
