package ru.yandex.solomon.util.collection;

import io.netty.util.Recycler;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

/**
 * @author Vladimir Gordiychuk
 */
public class RecyclableLong2ObjectMap<V> extends Long2ObjectOpenHashMap<V> {
    private static final Recycler<RecyclableLong2ObjectMap> RECYCLER = new Recycler<>() {
        protected RecyclableLong2ObjectMap newObject(Handle<RecyclableLong2ObjectMap> handle) {
            return new RecyclableLong2ObjectMap(handle);
        }
    };

    private final Recycler.Handle<RecyclableLong2ObjectMap> handle;

    private RecyclableLong2ObjectMap(Recycler.Handle<RecyclableLong2ObjectMap> handle) {
        this.handle = handle;
    }

    public static <V> RecyclableLong2ObjectMap<V> newInstance() {
        return (RecyclableLong2ObjectMap<V>) RECYCLER.get();
    }

    public boolean recycle() {
        this.clear();
        this.handle.recycle(this);
        return true;
    }
}
