package ru.yandex.solomon.util.collection;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class Slicer {

    public static <T> List<T> slice(List<T> list, int offset, int limit) {
        // TODO: using subList() will be even better
        return slice(list.stream(), offset, limit)
            .collect(Collectors.toList());
    }

    public static <T> Stream<T> slice(Stream<T> stream, int offset, int limit) {
        if (offset <= 0 && limit <= 0) {
            return stream;
        }

        if (offset > 0) {
            stream = stream.skip(offset);
        }

        if (limit > 0) {
            stream = stream.limit(limit);
        }

        return stream;
    }
}
