package ru.yandex.solomon.util.collection;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class StreamAndCount<T> {

    private final Stream<T> stream;
    private final int count;

    public StreamAndCount(Stream<T> stream, int count) {
        this.stream = stream;
        this.count = count;
    }

    public Stream<T> getStream() {
        return stream;
    }

    public int getCount() {
        return count;
    }

    public void forEach(Consumer<T> func) {
        stream.forEach(func);
    }

    public <U> StreamAndCount<U> map(Function<T, U> func) {
        return new StreamAndCount<>(stream.map(func), count);
    }

    public StreamAndCount<T> concat(StreamAndCount<T> rhs) {
        if (count == 0) {
            return rhs;
        } else if (rhs.count == 0) {
            return this;
        }
        return new StreamAndCount<>(Stream.concat(stream, rhs.stream), count + rhs.count);
    }
}
