package ru.yandex.solomon.util.collection.array;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.commune.mh.builder.MhCall;
import ru.yandex.commune.mh.builder.MhExpr;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class ArrayViewMh {

    static final ArrayViewType[] knownTypes = {
        BooleanArrayView.Type.I,
        IntArrayView.Type.I,
        LongArrayView.Type.I,
        DoubleArrayView.Type.I,
    };

    @Nonnull
    public static Class<?> arrayViewClassForArrayType(Class<?> arrayType) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("expected array type, but: " + arrayType.getSimpleName());
        }

        if (!arrayType.getComponentType().isPrimitive()) {
            throw new RuntimeException("TODO: " + arrayType);
        }

        for (ArrayViewType knownType : knownTypes) {
            if (knownType.arrayType().arrayClass() == arrayType) {
                return knownType.selfClass();
            }
        }

        throw new IllegalArgumentException("unsupported array view for: " + arrayType.getName());
    }

    public static MhExpr wrapArray(MhExpr array, MhExpr from, MhExpr to) {
        Class<?> arrayViewClass = arrayViewClassForArrayType(array.exprType());
        return MhCall.newInstance(arrayViewClass, array, from, to);
    }

    public static MhExpr wrapArray(MhExpr array) {
        Class<?> arrayViewClass = arrayViewClassForArrayType(array.exprType());
        return MhCall.newInstance(arrayViewClass, array);
    }

    public static MhExpr contains(MhExpr arrayView, MhExpr value) {
        return MhCall.instanceMethod(arrayView, "contains", value);
    }

    public static MhExpr allAre(MhExpr arrayView, MhExpr value) {
        return MhCall.instanceMethod(arrayView, "allAre", value);
    }

}
