package ru.yandex.solomon.util.collection.array;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.type.array.PrimitiveArrayType;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public interface ArrayViewType<A, E, S extends ArrayViewBase<A, E, S>> {

    Class<S> selfClass();

    @Nonnull
    S doConstruct(A array, int from, int to);

    @Nonnull
    S empty();

    @Nonnull
    default S construct(A array, int from, int to) {
        int arrayLength = arrayType().length(array);

        if (from < 0 || to < 0 || from > arrayLength || to > arrayLength) {
            throw new IllegalArgumentException("cannot slice from " + from + " to " + to);
        }

        if (from == to) {
            return empty();
        } else {
            return doConstruct(array, from, to);
        }
    }

    @Nonnull
    default S constructFromOffsetLength(A array, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length cannot be negative");
        }
        return construct(array, offset, offset + length);
    }

    @Nonnull
    PrimitiveArrayType<A, E> arrayType();

}
