package ru.yandex.solomon.util.collection.array;

import java.util.Arrays;
import java.util.Iterator;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.misc.algo.arrayList.ArrayListImpl;

/**
 * @see ArrayBuilder
 * @author Stepan Koltsov
 */
public class ObjectArrayBuilder<A> implements Iterable<A> {
    private A[] array;
    private int size;

    public ObjectArrayBuilder() {
        this.array = (A[]) Cf.ObjectArray.emptyArray();
        this.size = 0;
    }

    public ObjectArrayBuilder(A[] array) {
        this.array = array;
    }

    public void add(A a) {
        ArrayListImpl.prepareAdd(new ArrayListImpl.Accessor() {
            @Override
            public int capacity() {
                return array.length;
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public void reserveExact(int newCapacity) {
                array = Arrays.copyOf(array, newCapacity);
            }
        });
        array[size] = a;
        ++size;
    }

    public A[] getArray() {
        return array;
    }

    public int getSize() {
        return size;
    }

    @Override
    public Iterator<A> iterator() {
        return new Iterator<A>() {
            private int i = 0;

            @Override
            public boolean hasNext() {
                return i < size;
            }

            @Override
            public A next() {
                if (!hasNext()) {
                    throw new IllegalStateException("no such next element");
                }
                return array[i++];
            }
        };
    }
}
