package ru.yandex.solomon.util.collection.array;

/**
 * @author Sergey Polovko
 */
public class UnsignedLongArrays {

    public static int binarySearch(long[] array, long key) {
        return binarySearch(array, 0, array.length, key);
    }

    public static int binarySearch(long[] array, int fromIndex, int toIndex, long key) {
        rangeCheck(array.length, fromIndex, toIndex);

        int low = fromIndex;
        int high = toIndex - 1;

        while (low <= high) {
            final int mid = (low + high) / 2;
            final int cmp = Long.compareUnsigned(array[mid], key);

            if (cmp < 0) {
                low = mid + 1;
            } else if (cmp > 0) {
                high = mid - 1;
            } else {
                return mid;
            }
        }
        return -(low + 1);
    }

    private static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static boolean isSorted(long[] array) {
        if (array.length < 2) {
            return true;
        }

        long prev = array[0];
        for (int i = 1; i < array.length; i++) {
            final long curr = array[i];
            if (Long.compareUnsigned(prev, curr) > 0) {
                return false;
            }
            prev = curr;
        }
        return true;
    }
}
