package ru.yandex.solomon.util.collection.enums;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public abstract class EnumMapToAnyLong<E extends Enum<E>> extends EnumMapTo<E, Long> {
    public abstract void set(E e, long value);

    public long get(E e) {
        return getForOrdinal(e.ordinal());
    }

    public abstract long getForOrdinal(int ordinal);

    public long incrementAndGet(E e) {
        return addAndGet(e, 1);
    }

    public abstract long addAndGetForOrdinal(int ordinal, long delta);

    public long addAndGet(E e, long delta) {
        return addAndGetForOrdinal(e.ordinal(), delta);
    }

    public void addAll(EnumMapToAnyLong<E> that) {
        for (int ordinal = 0; ordinal < size(); ++ordinal) {
            addAndGetForOrdinal(ordinal, that.getForOrdinal(ordinal));
        }
    }

    @Override
    protected Long getValueForKey(int keyOrdinal) {
        return getForOrdinal(keyOrdinal);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EnumMapToAnyLong)) {
            return false;
        }

        if (this.size() != ((EnumMapToAnyLong) obj).size()) {
            return false;
        }

        for (int i = 0; i < this.size(); ++i) {
            if (this.getForOrdinal(i) != ((EnumMapToAnyLong) obj).getForOrdinal(i)) {
                return false;
            }
        }

        return true;
    }

    @Override
    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.size(); ++i) {
            hash = 31 * hash + Long.hashCode(this.getForOrdinal(i));
        }
        return hash;
    }
}
