package ru.yandex.solomon.util.collection.queue;

import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.ThreadSafe;

import ru.yandex.solomon.memory.layout.MemMeasurable;


/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
@ThreadSafe
public class ArrayListLockQueueMem<T extends MemMeasurable> extends ArrayListLockQueue<T> {

    public ArrayListLockQueueMem() {
    }

    public ArrayListLockQueueMem(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected long estimateMemory(T object) {
        return object.memorySizeIncludingSelf();
    }
}
