package ru.yandex.solomon.util.collection.unpacked.commonImpl;

import java.lang.reflect.Field;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class FieldNameAndType {
    public final String name;
    public final Class<?> type;

    public FieldNameAndType(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    public static FieldNameAndType fromField(Field field) {
        return new FieldNameAndType(field.getName(), field.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FieldNameAndType that = (FieldNameAndType) o;

        if (!name.equals(that.name)) return false;
        return type.equals(that.type);

    }

    @Override
    public int hashCode() {
        int result = name.hashCode();
        result = 31 * result + type.hashCode();
        return result;
    }
}
