package ru.yandex.solomon.util.collection.unpacked.commonImpl;

import java.util.List;

import javax.annotation.Nonnull;

import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.util.CheckClassAdapter;

import ru.yandex.misc.reflection.asm.AsmUtils;

/**
 * @author Stepan Koltsov
 */
class GenStruct {
    static Class<?> genStruct(ClassLoader classLoader, String className, List<FieldNameAndType> fields) {
        ClassWriter cw0 = genStructBytecode(fields, className);

        byte[] classBytes = cw0.toByteArray();
        return new ClassLoader(classLoader) {
            Class<?> define() {
                return defineClass(null, classBytes, 0, classBytes.length);
            }
        }.define();
    }

    @Nonnull
    private static ClassWriter genStructBytecode(List<FieldNameAndType> fields, String className) {

        ClassWriter cw0 = new ClassWriter(ClassWriter.COMPUTE_FRAMES | ClassWriter.COMPUTE_MAXS);

        CheckClassAdapter cw = new CheckClassAdapter(cw0, false);

        cw.visit(Opcodes.V1_8, Opcodes.ACC_PUBLIC + Opcodes.ACC_FINAL + Opcodes.ACC_SYNTHETIC,
            className, null, Type.getInternalName(Object.class), null);

        for (FieldNameAndType field : fields) {
            Class<?> elementType = field.type;
            cw.visitField(Opcodes.ACC_PRIVATE, field.name, Type.getDescriptor(elementType), null, null);
        }

        // default public constructor
        {
            org.objectweb.asm.commons.Method mm = new org.objectweb.asm.commons.Method("<init>", Type.VOID_TYPE, new Type[0]);
            MethodVisitor mv = cw.visitMethod(Opcodes.ACC_PUBLIC, mm.getName(), mm.getDescriptor(), null, null);
            GeneratorAdapter ga = new GeneratorAdapter(mv, Opcodes.ACC_PUBLIC, mm.getName(), mm.getDescriptor());

            ga.visitCode();

            // invoke super class constructor
            ga.loadThis();
            ga.invokeConstructor(Type.getType(Object.class), AsmUtils.OBJECT_CONSTRUCTOR_METHOD);

            ga.returnValue();

            ga.endMethod();
        }
        cw.visitEnd();
        return cw0;
    }
}
