package ru.yandex.solomon.util.collection.unpacked.commonImpl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.bolts.type.array.ArrayType;
import ru.yandex.commune.mh.Mhx;
import ru.yandex.commune.mh.builder.MhBuilder;
import ru.yandex.commune.mh.builder.MhCall;
import ru.yandex.commune.mh.builder.MhConst;
import ru.yandex.commune.mh.builder.MhExpr;
import ru.yandex.commune.mh.builder.MhExprArrays;
import ru.yandex.commune.mh.builder.MhSeq;

/**
 * @author Stepan Koltsov
 */
@ParametersAreNonnullByDefault
public class StructOfArrays {

    // X
    public final Class<?> clazz;


    private final ArraysField[] fields;

    // () -> X
    public final MethodHandle constructorNullsTyped;
    public final MethodHandle constructorNulls;

    // dst: X, int, src: X, int -> ()
    public final MethodHandle copyBetweenStructsTyped;
    public final MethodHandle copyBetweenStructs;

    // X, dst: int, src: int -> ()
    public final MethodHandle copyInStructTyped;
    public final MethodHandle copyInStruct;

    // dst: X, int, src: X, int, len: int -> ()
    public final MethodHandle copyRangeBetweenStructsTyped;
    public final MethodHandle copyRangeBetweenStructs;

    // X, dst: int, src: int, len: int
    public final MethodHandle copyRangeInStructTyped;
    public final MethodHandle copyRangeInStruct;

    // X, int, int -> ()
    public final MethodHandle swapInBigStructTyped;
    public final MethodHandle swapInBigStruct;

    // () -> X
    public final MethodHandle constructorEmptyTyped;
    public final MethodHandle constructorEmpty;

    // int -> X
    public final MethodHandle constructorAllocateTyped;
    public final MethodHandle constructorAllocate;

    // X, int -> ()
    public final MethodHandle resizeTyped;
    public final MethodHandle resize;


    public StructOfArrays(ClassLoader classLoader, String className, List<FieldNameAndType> fields) {
        try {
            clazz = GenStruct.genStruct(classLoader, className, fields);

            constructorNullsTyped = MhBuilder.oneshot0(this::newInstanceNulls);

            constructorNulls = MethodHandles.explicitCastArguments(
                constructorNullsTyped,
                MethodType.methodType(Object.class));

            this.fields = fields.stream()
                .map(t -> {
                    try {
                        return new ArraysField(clazz.getDeclaredField(t.name));
                    } catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                })
                .toArray(ArraysField[]::new);

            copyBetweenStructsTyped = MhBuilder.oneshot4(
                clazz, int.class, clazz, int.class,
                (dst, dstPos, src, srcPos) -> {
                    return invokeAll2(f -> {
                        MhExpr value = f.getFromStruct(src, srcPos);
                        return f.setToStruct(dst, dstPos, value);
                    });
                });
            copyBetweenStructs = MethodHandles.explicitCastArguments(
                copyBetweenStructsTyped,
                MethodType.methodType(void.class, Object.class, int.class, Object.class, int.class));

            copyInStructTyped = MhBuilder.oneshot3(
                clazz, int.class, int.class,
                (bigStruct, dst, src) -> {
                    return invokeAll2(f -> f.copyInBigStruct(bigStruct, dst, src));
                });
            copyInStruct = MethodHandles.explicitCastArguments(
                copyInStructTyped,
                MethodType.methodType(void.class, Object.class, int.class, int.class));

            copyRangeBetweenStructsTyped = MhBuilder.oneshot5(
                clazz, int.class, clazz, int.class, int.class,
                (dstS, dstPos, srcS, srcPos, len) -> {
                    return invokeAll2(f -> f.copyRangeBetweenStructs(dstS, dstPos, srcS, srcPos, len));
                });
            copyRangeBetweenStructs = MethodHandles.explicitCastArguments(
                copyRangeBetweenStructsTyped,
                MethodType.methodType(void.class, Object.class, int.class, Object.class, int.class, int.class));

            copyRangeInStructTyped = MhBuilder.oneshot4(
                clazz, int.class, int.class, int.class,
                (bigArray, dst, src, len) -> invokeAll2(f -> f.copyRangeInStruct(bigArray, dst, src, len)));
            copyRangeInStruct = MethodHandles.explicitCastArguments(
                copyRangeInStructTyped,
                MethodType.methodType(void.class, Object.class, int.class, int.class, int.class));

            swapInBigStructTyped = MhBuilder.oneshot3(
                clazz, int.class, int.class,
                (bigStruct, a, b) -> invokeAll2(f -> f.swapInBigStruct(bigStruct, a, b)));
            swapInBigStruct = MethodHandles.explicitCastArguments(swapInBigStructTyped,
                MethodType.methodType(void.class, Object.class, int.class, int.class));

            resizeTyped = MhBuilder.oneshot2(
                clazz, int.class,
                (bigStruct, newSize) -> {
                    return invokeAll2(f -> f.resizeFieldInStruct(bigStruct, newSize));
                });
            resize = MethodHandles.explicitCastArguments(resizeTyped, MethodType.methodType(void.class, Object.class, int.class));

            MethodHandle allocateArraysTyped = MhBuilder.oneshot2(
                clazz, int.class,
                (bigStruct, size) -> {
                    return invokeAll2(f -> f.allocateArrayInBigStruct(bigStruct, size));
                });

            constructorEmptyTyped = MhBuilder.oneshot0(() -> {
                MhExpr r = MhCall.newInstance(clazz);
                for (ArraysField field : this.fields) {
                    // TODO: ugly
                    r = field.allocateEmptyArrayInBigStruct(r).andReturnParam(0);
                }
                return r;
            });
            constructorEmpty = MethodHandles.explicitCastArguments(
                constructorEmptyTyped,
                MethodType.methodType(Object.class));

            constructorAllocateTyped = MethodHandles.collectArguments(Mhx.callAndReturnArg(allocateArraysTyped, 0), 0, constructorNullsTyped);
            constructorAllocate = MethodHandles.explicitCastArguments(
                constructorAllocateTyped,
                MethodType.methodType(Object.class, int.class));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private MhCall newInstanceNulls() {
        return MhCall.newInstance(clazz);
    }

    @Nonnull
    public ArraysField fieldByName(String name) {
        return Arrays.stream(fields).filter(a -> a.field.getName().equals(name)).findFirst().get();
    }


    public static class ArraysField {
        public final Field field;
        private final ArrayType<?, ?> arrayType;

        private MhExpr getArrayFromBigStruct(MhExpr bigStruct) {
            bigStruct.assertType(field.getDeclaringClass());
            return MhCall.getInstanceField(bigStruct, field);
        }

        public MhExpr setToStruct(MhExpr bigStruct, MhExpr pos, MhExpr value) {
            MhExpr array = getArrayFromBigStruct(bigStruct);
            return MhExprArrays.set(array, pos, value);
        }

        public MhExpr getFromStruct(MhExpr bigStruct, MhExpr pos) {
            MhExpr array = getArrayFromBigStruct(bigStruct);
            return MhExprArrays.get(array, pos);
        }

        private MhExpr copyInBigStruct(MhExpr bigStruct, MhExpr dst, MhExpr src) {
            MhExpr array = getArrayFromBigStruct(bigStruct);
            return MhExprArrays.copyElement(array, dst, src);
        }

        private MhCall setArrayInBigStruct(MhExpr bigStruct, MhExpr array) {
            return MhCall.setInstanceField(bigStruct, field, array);
        }

        private MhExpr swapInBigStruct(MhExpr bigStruct, MhExpr pos1, MhExpr pos2) {
            MhExpr array = getArrayFromBigStruct(bigStruct);
            return MhExprArrays.swap(array, pos1, pos2);
        }

        private MhExpr copyRangeInStruct(MhExpr bigArray, MhExpr dst, MhExpr src, MhExpr len) {
            MhExpr array = getArrayFromBigStruct(bigArray);
            return MhExprArrays.arrayCopyWithinArray(array, src, dst, len);
        }

        private MhExpr copyRangeBetweenStructs(MhExpr dstS, MhExpr dstPos, MhExpr srcS, MhExpr srcPos, MhExpr len) {
            MhExpr dstA = getArrayFromBigStruct(dstS);
            MhExpr srcA = getArrayFromBigStruct(srcS);
            return MhExprArrays.arrayCopy(srcA, srcPos, dstA, dstPos, len);
        }

        private MhExpr resizeFieldInStruct(MhExpr bigStruct, MhExpr newSize) {
            MhExpr array = getArrayFromBigStruct(bigStruct);
            MhExpr resized = MhExprArrays.copyOf(array, newSize);
            return setArrayInBigStruct(bigStruct, resized);
        }

        private MhCall allocateEmptyArrayInBigStruct(MhExpr bigStruct) {
            return setArrayInBigStruct(bigStruct, MhConst.auto(arrayType.emptyArray()));
        }

        private MhCall allocateArrayInBigStruct(MhExpr bigStruct, MhExpr size) {
            return setArrayInBigStruct(bigStruct, MhExprArrays.newArray(arrayType.arrayClass(), size));
        }



        private ArraysField(Field field) {
            this.field = field;

            field.setAccessible(true);

            arrayType = ArrayType.forArrayClass(field.getType());
        }

        // X, int, A -> ()
        public MethodHandle makeCopyFromArrayToAny(Field field) {
            return MhBuilder.oneshot3(
                this.field.getDeclaringClass(), int.class, field.getDeclaringClass(),
                (bigStruct, pos, target) -> {
                    MhExpr value = getFromStruct(bigStruct, pos);
                    return MhCall.setInstanceField(target, field, value);
                });
        }

        // X, int, A -> ()
        public MethodHandle makeCopyFromAnyToArrays(Field field) {
            return MhBuilder.oneshot3(
                this.field.getDeclaringClass(), int.class, field.getDeclaringClass(),
                (bigStruct, pos, source) -> {
                    MhCall value = MhCall.getInstanceField(source, field);
                    return setToStruct(bigStruct, pos, value);
                });
        }
    }

    private MethodHandle invokeAll(Function<ArraysField, MethodHandle> f) {
        return Mhx.invokeAll(Arrays.stream(fields).map(f).toArray(MethodHandle[]::new));
    }

    private MhExpr invokeAll2(Function<ArraysField, MhExpr> f) {
        return MhSeq.seq(Arrays.stream(fields).map(f).toArray(MhExpr[]::new));
    }


    public List<ArraysField> getFields() {
        return Arrays.asList(fields);
    }

}
