package ru.yandex.solomon.util.concurrent;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;


/**
 * @author Sergey Polovko
 */
public abstract class CountDownCallback {

    private static final AtomicIntegerFieldUpdater<CountDownCallback> countUpdater =
        AtomicIntegerFieldUpdater.newUpdater(CountDownCallback.class, "count");

    private volatile int count;

    public CountDownCallback(int count) {
        if (count < 1) {
            throw new IllegalArgumentException("count must be >= 1, but got: " + count);
        }
        this.count = count;
    }

    public void countDown() {
        if (countUpdater.decrementAndGet(this) == 0) {
            onComplete();
        }
    }

    protected abstract void onComplete();

    public abstract void onFailure(Throwable t);
}
