package ru.yandex.solomon.util.concurrent;

import java.util.concurrent.TimeUnit;

/**
 * @see ShutdownSignal
 *
 * @author Stepan Koltsov
 */
public class EventWithShutdown {

    private final AutoresetEvent event = new AutoresetEvent();
    private boolean shutdown = false;

    public boolean isShutdown() {
        return shutdown;
    }

    public void shutdown() {
        shutdown = true;
        event.signal();
    }

    public void await() {
        if (shutdown) {
            return;
        }
        event.await();
    }

    public boolean await(long millis) {
        return await(millis, TimeUnit.MILLISECONDS);
    }

    public boolean await(long time, TimeUnit unit) {
        if (shutdown) {
            return true;
        }
        return event.await(time, unit);
    }

    public void awaitRandom(long timeoutRandomAround, TimeUnit unit) {
        // +/- 1/4
        long timeout = timeoutRandomAround
            - (timeoutRandomAround >> 2)
            + ThreadUtils.currentThreadLocalRandom().nextLong(timeoutRandomAround >> 1);
        await(timeout, unit);
    }

    public void signal() {
        event.signal();
    }

    public boolean awaitUntil(long instant) {
        if (shutdown) {
            return true;
        }
        return event.awaitUntil(instant);
    }
}
