package ru.yandex.solomon.util.concurrent;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * @author Stepan Koltsov
 */
public class ForkJoinPools {

    public static ForkJoinPool newPool(int parallelism, String name) {
        // TODO: implements FastThreadLocalAccess as only netty 5.0 will be ready (gordiychuk@)
        return new ForkJoinPool(parallelism, new ForkJoinPool.ForkJoinWorkerThreadFactory() {
            private final AtomicInteger i = new AtomicInteger();

            @Override
            public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
                ForkJoinWorkerThread t = new ForkJoinWorkerThread(pool) {};
                t.setName(name + "-" + i.getAndIncrement());
                return t;
            }
        }, null, false);
    }

}
