package ru.yandex.solomon.util.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * @see EventWithShutdown
 *
 * @author Stepan Koltsov
 */
public class ShutdownSignal {

    private final CountDownLatch downLatch = new CountDownLatch(1);

    public void shutdown() {
        downLatch.countDown();
    }

    public void await(long timeout, TimeUnit unit) {
        try {
            downLatch.await(timeout, unit);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void awaitRandom(long timeoutRandomAround, TimeUnit unit) {
        // +/- 1/4
        long timeout = timeoutRandomAround
            - (timeoutRandomAround >> 2)
            + ThreadUtils.currentThreadLocalRandom().nextLong(timeoutRandomAround >> 1);
        await(timeout, unit);
    }

    public void awaitUntil(long instant) {
        long now = System.currentTimeMillis();
        if (now >= instant) {
            return;
        }
        await(instant - now, TimeUnit.MILLISECONDS);
    }

    public boolean isShutdown() {
        return downLatch.getCount() == 0;
    }

    public void checkShutdown() {
        if (isShutdown()) {
            throw new RuntimeException("shutdown");
        }
    }

    @Override
    public String toString() {
        return "ShutdownSignal{shutdown=" + isShutdown() + "}";
    }
}
