package ru.yandex.solomon.util.concurrent;

import java.util.concurrent.ThreadFactory;

import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.ThreadLocalRandom;

/**
 * @author Sergey Polovko
 */
public final class ThreadUtils extends ru.yandex.misc.thread.ThreadUtils {
    private ThreadUtils() {}

    public static ThreadFactory newThreadFactory(Class<?> clazz) {
        return newThreadFactory(clazz.getSimpleName());
    }

    public static ThreadFactory newThreadFactory(String threadNamePrefix) {
        // For performance reasons here we use Netty's DefaultThreadFactory which creates FastThreadLocalThread.
        // This thread class provides fast access to FastThreadLocal variables.
        return new DefaultThreadFactory(threadNamePrefix);
    }

    public static ThreadLocalRandom currentThreadLocalRandom() {
        return ThreadLocalRandom.current();
    }
}
