package ru.yandex.solomon.util.file;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.io.IoFunction;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public class DevNullFileStorage implements FileStorage {
    @Override
    public <V> void save(String fileName, V value, IoFunction<V, String> serialize) {
        /* no-op */
    }

    @Nullable
    @Override
    public <V> V load(String fileName, IoFunction<String, V> deserialize) {
        return null;
    }

    @Override
    public <V> void saveValues(String fileName, Collection<V> values, IoFunction<V, String> serializeOne) {
        /* no-op */
    }

    @Nullable
    @Override
    public <V> List<V> loadValues(String fileName, IoFunction<String, V> deserializeOne) {
        return null;
    }
}
