package ru.yandex.solomon.util.file;

import java.util.Collection;
import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.util.io.IoFunction;

/**
 * @author Stanislav Kashirin
 */
@ParametersAreNonnullByDefault
public interface FileStorage {

    <V> void save(String fileName, V value, IoFunction<V, String> serialize) throws Exception;

    @Nullable
    <V> V load(String fileName, IoFunction<String, V> deserialize) throws Exception;

    <V> void saveValues(String fileName, Collection<V> values, IoFunction<V, String> serializeOne) throws Exception;

    @Nullable
    <V> List<V> loadValues(String fileName, IoFunction<String, V> deserializeOne) throws Exception;

}
