package ru.yandex.solomon.util.future;

import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

import io.grpc.Status;

import static java.util.concurrent.CompletableFuture.completedFuture;

/**
 * @author Vladimir Gordiychuk
 */
public class RetryContext implements AutoCloseable {
    private final RetryConfig retryConfig;
    private volatile boolean closed;

    public RetryContext(RetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    public <T> CompletableFuture<T> retry(Supplier<CompletableFuture<T>> supplier) {
        try {
            var future = RetryCompletableFuture.runWithRetries(() -> {
                if (closed) {
                    return completedFuture(null);
                }

                return supplier.get();
            }, retryConfig);

            return future.thenApply(result -> {
                if (closed) {
                    throw closeException();
                }

                return result;
            });
        } catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private RuntimeException closeException() {
        return Status.CANCELLED.withDescription("closed").asRuntimeException();
    }

    @Override
    public void close() {
        closed = true;
    }
}
